<?php
# CSS
function css($file)
{
	$cache = WEB.'/'.substr(\Pawn::cache(\lib\Template::public_file('css/'.$file.'.css'), array('\\lib\\Template', 'css'), true, null), strlen(ROOT));
	
	return '<link rel="stylesheet" href="'.$cache.'"/>';
}

# JS
function js($file)
{
	return '<script type="text/javascript" src="'.serve('js/'.$file.'.js').'"></script>';
}

# Public file
function public_file($instance, $field, $default='')
{
	return $instance->file($field, $default);
}

# Time ago
function time_ago($time=false)
{
	if(!$time)
	{
		\lib\Lang::load('time_ago');
		
		$response = '<script type="text/javascript">';
		
		$response .= 'setInterval(function()
		{
			var lang = '.json_encode(\lib\Lang::get('time_ago')).';
			var time = parseInt(new Date().getTime()/1000);
			
			$(".time_ago").each(function()
			{
				var message = false, n = 0;
				var seconds = time - parseInt($(this).attr("timestamp"));
				
				if(seconds < 60)
				{
					message = "now";
				} else if(seconds < 3600)
				{
					message = "minutes";
					
					n = Math.floor(seconds/60);
				}
				
				if(message)
				{
					if(typeof(lang[message]) === "string")
					{
						this.innerHTML = lang[message].replace("{n}", n);
					} else
					{
						if(n in lang[message])
						{
							this.innerHTML = lang[message][n];
						} else
						{
							this.innerHTML = lang[message].n.replace("{n}", n);
						}
					}
				}
			});
		}, 30000);';
		
		$response .= '</script>';
		
		return $response;
	}
	
	return '<span class="time_ago" timestamp="'.$time.'">'.\Pawn::time_ago($time).'</span>';
}

# Get
function get($parent, $child)
{
	if(!isset($parent))
	{
		return null;
	}
	
	$args = func_get_args();
	
	if(is_array($parent))
	{
		isset($parent[$child]) and $value = $parent[$child];
	} elseif(is_object($parent))
	{
		if(isset($parent->$child))
		{
			$value = $parent->$child;
		} elseif(method_exists($parent, $child))
		{
			if(isset($args[2]) && is_array($args[2]))
			{
				return call_user_func_array(array($parent, $child), $args[2]);
			} else
			{
				$value = $parent->$child();
			}
		} elseif(method_exists($parent, '__get'))
		{
			$value = $parent->__get($child);
		}
	}
	
	if(!isset($value))
	{
		return null;
	}
	
	if(count($args) == 2)
	{
		return $value;
	} else
	{
		$args[1] = $value;
		
		return call_user_func_array('get', array_slice($args, 1));
	}
}

# Lang
function __()
{
	return call_user_func_array(array('\lib\Lang', 'get'), func_get_args());
}

function lang_date($format, $time=false)
{
	return \lib\Lang::get_date($format, $time);
}

# Path
function path($controller, $action='index', $args=array())
{
	return \Pawn::path($controller, $action, $args);
}

function http_path($controller=false, $action='index', $args=array())
{
	return \Pawn::http_path($controller, $action, $args);
}

# Serve static files
function serve()
{
	$file = implode('', func_get_args());
	
	$paths = array
	(
		'public/template/'.\Pawn::setting('template').'/',
		'public/',
		'fw/public/'
	);
	
	foreach($paths as $path)
	{
		if(file_exists(ROOT.$path.$file))
		{
			return WEB.'/'.$path.$file;
		}
	}
}

# Runtime (page load time)
function runtime($places=3)
{
	return round(microtime(true) - MT, $places);
}

# Setting
function setting($key)
{
	return \Pawn::setting($key);
}

# Pagination
function pagination($current, $total, $path, $link='<a href="{path}">{page}</a>', $link_current='<a class="current">{page}</a>', $view=2, $reverse=false)
{
	$start = $current - $view;
	$end = $current + $view;
	
	if($start < 1)
	{
		$end += 1 - $start;
	} elseif($end > $total)
	{
		$start += $total - $end;
	}
	
	if($start < 1)
	{
		$start = 1;
	}
	
	if($end > $total)
	{
		$end = $total;
	}
	
	$content = array();
	
	for($page=$start; $page<=$end; $page++)
	{
		$content[] = str_replace(array('{path}', '{page}'), array(str_replace('{page}', $page, $path), $page), ($page == $current)?$link_current:$link);
	}
	
	return implode('', $reverse?array_reverse($content):$content);
}

# Date
function get_date($time=null)
{
	return \Pawn::get_date($time);
}

# Advertisement
function ad($width, $height)
{
	return \Pawn::setting('ad_'.$width.'x'.$height);
}

# User-text
function usertext($msg)
{
	return is_array($msg)?$msg[0]:nl2br(str_replace(array('<', '>'), array('&lt;', '&gt;'), $msg));
}

# In bytes
function inBytes($size)
{
	return \Pawn::inBytes($size);
}

# Copyrights
function copyrights()
{
	$year = date('Y');
	$setup = date('Y', \Pawn::setting('setup'));
	
	return \Pawn::setting('title').' &copy; '.(($year == $setup)?$year:$setup.'-'.$year).' '.\Pawn::setting('company');
}

# Wrap text
function wrap_text($wrapper, $text)
{
	$tag = explode(' ', $wrapper, 2);
	
	return '<'.$wrapper.'>'.$text.'</'.$tag[0].'>';
}

# Query-string append
function qsa($qs)
{
	$path = WEB.(defined('MOD_REWRITE')?'':'/index.php?p=').ROUTE;
	
	$i = 0;
	
	foreach($qs as $key=>$value)
	{
		if(!$i++ && defined('MOD_REWRITE'))
		{
			$path .= '?';
		} else
		{
			$path .= '&';
		}
		
		$path .= $key.'='.$value;
	}
	
	return $path;
}

# Anchor
function anchor($href, $value='{value}')
{
	return '<a href="'.$href.'">'.$value.'</a>';
}